//------------------------------------------------------------------------------
// File: client_savetaskbuttons.cs
// This file is used to save all task buttons on the client side.
//
// Copyright Sandlot Games, 2008
// Author: Michael Felice
//------------------------------------------------------------------------------

// this initializes the task button save process
function TaskButtonSaveToFile()
{
   // build the list of task button targets ghost id
   %list = "";
   %count = slgGetTaskButtonCount();
   for (%index = 0; %index < %count; %index++)
   {
      %button = slgGetTaskButton(%index);
      %ghostID = ServerConnection.getGhostID(%button.target);
      
      %add = true;
      %checkCount = getWordCount(%list);
      for (%checkIndex = 0; %checkIndex < %checkCount; %checkIndex++)
      {
         %check = getWord(%list, %checkIndex);
         if (%check == %ghostID)
         {
            %add = false;
            break;
         }
      }
      
      if (%add == true)
      {
         %list = %list @ %ghostID @ " ";
      }
   }
   
   slgSaveInt(getWordCount(%list));
   
   // send this list to the server (the server will generate a list
   // of save ids and save them to the save file)
   commandToServer('TaskButtonSaveToFile', %list);
}

function clientCmdTaskButtonSaveToFile()
{
   /*
   // save the other details for each task button
   %count = slgGetTaskButtonCount();
   for (%index = 0; %index < %count; %index++)
   {
      // get the button
      %button = slgGetTaskButton(%index);
      %button.target.saveToFile();
   }
   */
   
   // notify the server that alerts have finished saving
   commandToServer('AlertSaveToFileDone');
}

function TaskButtonLoadFromFile()
{
   // notify the server that the list of targets needs to be loaded
   commandToServer('TaskButtonsLoadFromFile');
}

function clientCmdTaskButtonLoadFromFile(%list)
{
   /*
   %count = getWordCount(%list);
   for (%index = 0; %index < %count; %index++)
   {
      %ghostID = getWord(%list, %index);
      %target = ServerConnection.resolveGhostID(%ghostID);
      %target.loadFromFile();
      
      // add the button to the controls
      TaskButtonGroup.addGuiControl(%button);
   }
   */
   
   // notify the server that we are done loading buttons
   commandToServer('AlertLoadFromFileDone');
}
